$Instances = (get-itemproperty 'HKLM:\SOFTWARE\Microsoft\Microsoft SQL Server').InstalledInstances

#get-date >>C:\Zabbix\Logs\Instances.log

if($Instances -eq $null) {Write-output "No instances detected : $Instances"}


else {
$idx = 1
write-host "{"
write-host " `"data`":[`n"
foreach ($Instance in $Instances)
{   if($Instance -eq "MSSQLSERVER"){$Instance = "SQLServer"}
	else {$Instance = "MSSQL$" + $Instance}
    if ($idx -lt $Instances.Count)
    {
        $line= "{ `"{#INSTANCENAME}`" : `"" + $Instance + "`" },"
        write-host $line
    }
    elseif ($idx -ge $Instances.Count)
    {
	$line= "{ `"{#INSTANCENAME}`" : `"" + $Instance + "`" }"
    	write-host $line
    }
    $idx++;
}
write-host
write-host " ]"
write-host "}"
}